<?php
/**
 * Plugin Name: Secure Two Factor Authentication
 * Plugin URI: https://yourwebsite.com/
 * Description: A secure two-factor authentication plugin for WordPress with TOTP support.
 * Version: 1.0.0
 * Author: Your Name
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: secure-two-factor-auth
 * Requires at least: 5.0
 * Tested up to: 6.3
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('S2FA_PLUGIN_URL', plugin_dir_url(__FILE__));
define('S2FA_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('S2FA_VERSION', '1.0.0');

// Main plugin class
class SecureTwoFactorAuth {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('plugins_loaded', array($this, 'init'));
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    public function init() {
        // Load text domain for translations
        load_plugin_textdomain('secure-two-factor-auth', false, dirname(plugin_basename(__FILE__)) . '/languages');
        
        // Include required files
        $this->includes();
        
        // Initialize components
        $this->init_hooks();
    }
    
    private function includes() {
        require_once S2FA_PLUGIN_PATH . 'includes/class-s2fa-totp.php';
        require_once S2FA_PLUGIN_PATH . 'includes/class-s2fa-user.php';
        require_once S2FA_PLUGIN_PATH . 'includes/class-s2fa-login.php';
        require_once S2FA_PLUGIN_PATH . 'includes/class-s2fa-admin.php';
    }
    
    private function init_hooks() {
        // Initialize login handler
        if (class_exists('S2FA_Login')) {
            new S2FA_Login();
        }
        
        // Initialize admin interface
        if (is_admin() && class_exists('S2FA_Admin')) {
            new S2FA_Admin();
        }
    }
    
    public function activate() {
        // Code to run on plugin activation
        if (!current_user_can('activate_plugins')) {
            return;
        }
        
        // Add default options
        add_option('s2fa_enabled', false);
        add_option('s2fa_enforce_all_users', false);
        
        // Create necessary database tables if needed
        $this->create_tables();
    }
    
    public function deactivate() {
        // Code to run on plugin deactivation
        if (!current_user_can('activate_plugins')) {
            return;
        }
        
        // Clean up temporary data if needed
        // Note: Don't delete user settings on deactivation, only on uninstall
    }
    
    private function create_tables() {
        global $wpdb;
        
        // Example: Create table for backup codes
        $table_name = $wpdb->prefix . 's2fa_backup_codes';
        
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            user_id bigint(20) NOT NULL,
            code varchar(20) NOT NULL,
            used tinyint(1) DEFAULT 0,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY user_id (user_id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}

// Initialize the plugin
SecureTwoFactorAuth::get_instance();