<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
function uport_get_new_category_page() {

    $step1_head = "General";

        $tabstr = "<div class='uport_tabs'>
            <div data-tabid='1' id='uport1_tab' class='uport_tab active'>" . $step1_head . "</div>
        </div>";
    ?>

    <div class="wrap uport-itempanel-wrap">

    <?php
    if (!isset($_GET['cat_id'])) {
        ?>
        <h2 class='uport_head'><?php _e('Add New Category', 'uport-framework'); ?></h2>
        <form method="post" enctype="multipart/form-data" action="<?php echo esc_url(add_query_arg(array('type' => 'save'))); ?>">

                <?php echo $tabstr; ?>

            <div class='uport_contents'>
                <div data-contentid='1' id='uport1_content' class='uport_content active'>
                    <div class='tabcontent_wrap'>

                        <table border=0 class='formtable'>						 
                            <tr><td class='tit'><span><?php _e('Category name', 'uport-framework'); ?></span></td>
                                <td><input type="text" name="title" id="title" class="regular-text"></td>
                            </tr>
                            <tr><td class='tit'><span><?php _e('Description', 'uport-framework'); ?></span></td>
                                <td><textarea name="description" id="description" ></textarea></td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
        <input type="hidden" name="which" id="which" value="new_category"/>
        <input type="submit" value="<?php _e('Save New Category', 'uport-framework'); ?>" class="savebut1">


        </form>
        <?php
    } else {
        $cat_id = $_GET['cat_id'];
        global $wpdb;
        $cat = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'uport_categories WHERE cat_id=' . $cat_id);
        ?>

        <h2 class='uport_head'><?php _e('Edit Category', 'uport-framework'); ?><a href="<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_add_new_category" title="" class="add-new-h2"><?php _e('Add New', 'uport-framework'); ?></a></h2>
        <?php if (isset($msg)) { ?><div style="padding: 5px" class="updated"><b><?php
            if ($msg == 'added') {
                _e('Category added successfully', 'uport-framework');
            } else {
                _e('Category edited successfully', 'uport-framework');
            }
            ?></b></div><?php } ?>

                <?php echo $tabstr; ?>

        <form method="post" enctype="multipart/form-data" action="<?php echo esc_url(add_query_arg(array('type' => 'save'))); ?>">

            <div class='uport_contents'>
                <div data-contentid='1' id='uport1_content' class='uport_content active'>
                    <div class='tabcontent_wrap'>

            <table border=0 class='formtable'>
                <tr><td class='tit'><span><?php _e('Category name', 'uport-framework'); ?></span></td>
                    <td><input type="text" name="title" id="title" class="regular-text" value="<?php echo($cat->cat_name); ?>"></td>
                </tr>
                <tr>
                <tr><td class='tit'><span><?php _e('Description', 'uport-framework'); ?></span></td>
                    <td><textarea name="description" id="description"><?php echo($cat->cat_description); ?></textarea></td>
                </tr>
            </table>

                    </div>
                </div>
            </div>

                        <input type="hidden" name="cat_id" id="cat_id" value="<?php echo($cat_id); ?>"/>
                        <input type="hidden" name="which" id="which" value="update_category"/>
                        <input type="submit" value="<?php _e('Save Category', 'uport-framework'); ?>" class="savebut1">

        </form>
        </div> <!-- .inside -->
        </div>
        </div> <!-- #post-body-content -->
        </div> <!-- #post-body -->

        </div> <!-- .metabox-holder -->
        </div> <!-- .wrap -->

        <?php
    }
}

function uport_get_new_category_page_insert() {
    global $wpdb;
    if ($_POST['which'] == 'new_category') {
        $cat_name = $_POST['title'];
        $cat_description = $_POST['description'];
        $wpdb->query($wpdb->prepare('
	INSERT INTO ' . $wpdb->prefix . 'uport_categories(cat_name, cat_description)
	VALUES( %s, %s)', $cat_name, $cat_description));
    }
}

function uport_get_new_category_page_update() {
    global $wpdb;
    if ($_POST['which'] == 'update_category') {
        $cat_id = $_POST['cat_id'];
        $cat_name = $_POST['title'];
        $cat_description = $_POST['description'];
        $wpdb->query($wpdb->prepare('UPDATE ' . $wpdb->prefix . 'uport_categories SET 
	cat_name = \'' . $cat_name . '\', cat_description =\'' . $cat_description . '\' WHERE cat_id = %d ', $cat_id));
    }
}

function uport_get_categories_page() {
    global $wpdb;
    ?>
    <div class="wrap">
        <h2 class='uport_head'><?php _e('Categories ', 'uport-framework'); ?><a href="<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_add_new_category" title="" class="add-new-h2"><?php _e('Add New', 'uport-framework'); ?></a></h2>
        <?php
        echo "<span class='uport_msg'></span>";
        $printdata = "";
        $cats = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'uport_categories');
        if ($cats == null) {
            echo(__('You don\'t have any categories.', 'uport-framework') . '&nbsp;' . __('Please', 'uport-framework') . '&nbsp;<a href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_category" title="">' . __('Add a New Category', 'uport-framework') . '</a>' );
        } else {
            ?>
            <table border=0 cellspacing=0 cellpadding=0 class='viewtable'>
                <tr>
                    <td style="width:5%;"><?php _e('Category&nbsp;Id', 'uport-framework'); ?></td>
                    <td style="width:20%;"><?php _e('Name', 'uport-framework'); ?></td>
                    <td style="width:40%;"><?php _e('Description', 'uport-framework'); ?></td>
                    <td style="width:20%;"><?php _e('Actions', 'uport-framework'); ?></td>
                    <td style='width:10%'><input type='checkbox' class='uportallrow' name='uportallrow' id='uportallrow'/>&nbsp;<?php _e('Select', 'uport-framework'); ?></td>
                </tr>
                <?php
                foreach ($cats as $cat) {
                    echo('<tr>
                    <td>' . __($cat->cat_id, 'uport-framework') . '</td>
					<td>
						<a href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_category&cat_id=' . $cat->cat_id . '">' . __($cat->cat_name, 'uport-framework') . '</a>
					</td>
					<td>' . __($cat->cat_description, 'uport-framework') . '</td>
					<td class="actions">
						<a class="edit" href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_category&cat_id=' . $cat->cat_id . '">Edit</a>
                        <a class="smallbutton delete" href="javascript:;" onclick=\'uport_actionthis("' . esc_url(add_query_arg(array("page" => "uport_categories"))) . '","' . $cat->cat_id . '","del_category")\' >Del</a>
                        <a class="smallbutton copy" href="javascript:;" onclick=\'uport_actionthis("' . esc_url(add_query_arg(array("page" => "uport_categories"))) . '","' . $cat->cat_id . '","copy_category")\' >Copy</a>
						</td>

                    <td align="right" class="selectrow">
                    <input type="checkbox" class="uportrow" name="uportrow" id="uportrow_'.$cat->cat_id.'" data-id="'.$cat->cat_id.'" value="'.$cat->cat_id.'" data-type="portfolio"/>
                    </td>                        
				</tr>');
                }
                ?>
            </table>
            <?php

            echo "<div class='selactions_wrap'><button class='deletesel uport_selactions' disabled href='javascript:;' data-type='category' data-action='delete' >".__('Delete Selected', 'uport-framework')."</button>
            <button class='copysel uport_selactions' disabled href='javascript:;' data-type='category' data-action='copy' >".__('Copy Selected', 'uport-framework')."</button></div>
                ";
        }
    }
    ?>