<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
function uport_get_new_item_page() {
    global $wpdb;

    $step1_head = __('General', 'uport-framework');
    $step2_head = __('Media', 'uport-framework');
    $step3_head = __('Lightbox', 'uport-framework');

        $tabstr = "<div class='uport_tabs'>
            <div data-tabid='1' id='uport1_tab' class='uport_tab active'>" . $step1_head . "</div>
            <div data-tabid='2' id='uport2_tab' class='uport_tab'>" . $step2_head . "</div>
            <div data-tabid='3' id='uport3_tab' class='uport_tab'>" . $step3_head . "</div>
        </div>";

    $lightbox_mediatype = "none:None|image:Image (like .jpg,.png)|video:External Video URL (like YouTube)|videofile:Default Video Player (like .mp4)|audio:Default Audio Player (like .mp3)|embed:Embed HTML Code";


    ?>
    <div class="wrap uport-itempanel-wrap">
        <?php if (!isset($_GET['item_id'])) { ?>
            <h2 class='uport_head'><?php _e('Add New Item', 'uport-framework'); ?></h2>
            <?php
            if (isset($_POST['which']) && $_POST['which'] == 'new_item' && $_GET['type'] == 'save') {
                echo "<span class='uport_msg'>New Item Saved Successfully!</span>";
            }
            ?>




            <form method="post" enctype="multipart/form-data" action="<?php echo esc_url(add_query_arg(array('type' => 'save'))); ?>">

                <?php echo $tabstr; ?>

            <div class='uport_contents'>

                <div data-contentid='1' id='uport1_content' class='uport_content active'>
                    <div class='tabcontent_wrap'>

                        <table border=0 class='formtable'>
                            <tr><td class='tit'><span><?php _e('Item Title', 'uport-framework'); ?></span></td>
                                <td><input type="text" name="title" id="title" class="regular-text"></td>
                            </tr>

                            <tr><td class='tit'><span><?php _e('Description', 'uport-framework'); ?></span></td>
                                <td><textarea name="description" id="description"></textarea>
                                </td></tr>

                            <tr><td class='tit'><span><?php _e('Slug', 'uport-framework'); ?></span></td>
                                <td><input type="text" name="slug" id="slug" class="regular-text"></td>
                            </tr>
                            <tr>
                                <td class='tit'><span><?php _e('Price', 'uport-framework'); ?></td>
                                <td><input type="text" name="price" id="price" class="regular-text"></td>
                            </tr>

                                        <!--						<tr><td class='tit'><span><?php _e('Date', 'uport-framework'); ?></span></td>
                                        <td><input type="text" name="date" id="date"></td>
                                        </tr>-->
                            <tr><td class='tit'><span><?php _e('URL Link', 'uport-framework'); ?></span></td>
                                <td><input type="text" name="link" id="link" class="regular-text">
                                    <span class="descinfo"><?php _e('Add a URL to your item. If left empty no url button will be displayed', 'uport-framework'); ?></span>
                                </td></tr>

                            <?php 
                            if(file_exists(plugin_dir_path( __FILE__ ).'../lib/uport-multicat-index.mc.php')){
                                $catids = "0:Select (multi)|".uport_catstrs_ordered('str');
                            } else {
                                $catids = "0:Select (multi)|".uport_catstrs('str');
                            }

                                $valarr = array("category" => "");
                                uport_field('Portfolio Categories', 'category', 'select_multi', '', $catids, 'Pick categories to display portfolio items from.', '1', $valarr, " uport-combobox-multi ");
                            ?>

                        </table>
                    </div>
                </div>


                <div data-contentid='2' id='uport2_content' class='uport_content '>
                    <div class='tabcontent_wrap'>
                        <table border=0 class='formtable'>
                            <tr><td class='tit'><span><?php _e('Preview Image', 'uport-framework'); ?></span></td>
                                <td>
                                    <input type="text" name="thumbnail_adr" id="thumbnail_adr" class="regular-text" /><input type="button" name="thumbnail" id="thumbnail" class="uport-upload-but" value="<?php _e('Upload Image', 'uport-framework'); ?>" />
                                    <div id="thumbnail_adr_area" class='upload-image-area'></div>
                                    <span class="descinfo"><?php _e('Image for preview purpose.', 'uport-framework'); ?></span>
                                </td></tr>
                            <tr><td class='tit'><span><?php _e('OR Embed Code in Preview', 'uport-framework'); ?></span></td>
                                <td><textarea name="thumbnailembed_adr" id="thumbnailembed_adr" class="regular-text"></textarea>
                                    <span class="descinfo"><?php _e('Use a small EMBED code like YouTube, Vimeo, Dailymotion, Instagram etc. embed codes. You can also embed AUDIO codes like SoundCloud here. You will have to select Embed Media Effect while building your portfolio.', 'uport-framework'); ?></span>
                                </td></tr>
                        </table>
                    </div>
                </div>


            <div data-contentid='3' id='uport3_content' class='uport_content '>
                <div class='tabcontent_wrap'>
                    <table border=0 class='formtable'>
                        <tr><td class='tit'><span><?php _e('Larger Image (for Lightbox)', 'uport-framework'); ?></span></td>
                            <td><input type="text" name="image_adr" id="image_adr" class="regular-text" />
                                <input type="button" name="image" id="image" class="uport-upload-but" value="<?php _e('Upload Image', 'uport-framework'); ?>" />
                                <div id="image_adr_area" class='upload-image-area'></div>
                                <span class="descinfo"><?php _e('This is the Image will be displayed when you show the item details in lightbox pop up. Leave blank to show the preview image.', 'uport-framework'); ?></span>
                            </td>
                        </tr>
                        <tr><td class='tit'><span><?php _e('Or External Video URL (for Lightbox)', 'uport-framework'); ?></span></td>
                            <td><input type="text" name="ext_adr" id="ext_adr" class="regular-text" />
                                
                                <span class="descinfo"><?php _e('Enter only URL. Do not embed code. The video type will be detected automatically. This is the Video will be displayed when you show the item details in lightbox. Eg: http://www.youtube.com/watch?v=6A9JVMLAQUk', 'uport-framework'); ?></span>
                            </td>
                        </tr>
                        <tr><td class='tit'><span><?php _e('Or Video URL (for Lightbox)', 'uport-framework'); ?></span></td>
                            <td><input type="text" name="extvideo_adr" id="extvideo_adr" class="regular-text" />
                                <input type="button" name="extvideourl" id="extvideourl" class="uport-upload-but" value="<?php _e('Upload Video', 'uport-framework'); ?>" />
                                <div id="extvideourl_area" class='upload-image-area'></div>
                                <span class="descinfo"><?php _e('Enter only URL. Do not embed code here. The video type will be detected automatically. This is the video, will open up in lightbox using user browser&apos;s inbuilt video player. Eg: http://www.abcxyz.com/video.mp4', 'uport-framework'); ?></span>
                            </td>
                        </tr>
                        <tr><td class='tit'><span><?php _e('Or Audio URL (for Lightbox)', 'uport-framework'); ?></span></td>
                            <td><input type="text" name="extaudio_adr" id="extaudio_adr" class="regular-text" />
                                <input type="button" name="extaudiourl" id="extaudiourl" class="uport-upload-but" value="<?php _e('Upload Audio', 'uport-framework'); ?>" />
                                <div id="extaudiourl_area" class='upload-image-area'></div>
                                <span class="descinfo"><?php _e('Enter only URL. Do not embed code here. The audio type will be detected automatically. This is the audio will open up in lightbox using user browser&apos;s inbuilt audio player. Eg: http://www.abcxyz.com/audio.mp3', 'uport-framework'); ?></span>
                            </td>
                        </tr>
                        <tr><td class='tit'><span><?php _e('Or EMBED HTML CODE (for Lightbox)', 'uport-framework'); ?></span></td>
                            <td><textarea name="extembed_adr" id="extembed_adr" class="regular-text" /></textarea>
                                
                                <span class="descinfo"><?php _e('Enter your EMBED CODE. This code can be a video embeded code, embeded audio code or any HTML code. It will be displayed in Lightbox', 'uport-framework'); ?></span>
                            </td>
                        </tr>

                        <?php
                            $valarr = "";
                            uport_field('Lightbox Media Type', 'exttype_adr', 'select', 'none', $lightbox_mediatype, 'Please pick the type of your lightbox media of item. Eg: video or image or any other', '1', $valarr, "");
                        ?>

                    </table>
                </div>
            </div>
        </div>
                <input type="hidden" name="which" id="which" value="new_item"/>
                <input type="submit" value="<?php _e('Save New Item', 'uport-framework'); ?>" class="savebut1">
            </form>
            <?php
        } else {
            $item_id = $_GET['item_id'];

            global $wpdb;
            $item = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'uport_items WHERE item_id=' . $item_id);

            $item->item_image = uport_upload_url($item->item_image);
            $item->item_thumbnail = uport_upload_url($item->item_thumbnail);
            $item->item_link = uport_upload_url($item->item_link);
            $item->item_thumbnailembed = uport_upload_url($item->item_thumbnailembed);
            $item->item_ext = uport_upload_url($item->item_ext);
            $item->item_extvideo = uport_upload_url($item->item_extvideo);
            $item->item_extaudio = uport_upload_url($item->item_extaudio);
            $item->item_extembed = uport_upload_url($item->item_extembed);



            ?>
            <h2 class='uport_head'><?php _e('Edit Item', 'uport-framework'); ?><a href="<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_add_new_item" title="" class="add-new-h2"><?php _e('Add New', 'uport-framework'); ?></a></h2>
            <?php
            if (isset($_POST['which']) && $_POST['which'] == 'update_item' && $_GET['type'] == 'save') {
                echo "<span class='uport_msg'>Item Updated Successfully!</span>";
            }
            ?>
                <?php if (isset($msg)) { ?><div style="padding: 5px" class="updated"><b><?php
                    if ($msg == 'added') {
                        _e('Item added successfully', 'uport-framework');
                    } else {
                        _e('Item edited successfully', 'uport-framework');
                    }
                    ?></b></div><?php } ?>
         
            <form method="post" enctype="multipart/form-data" action="<?php echo esc_url(add_query_arg(array('type' => 'save'))); ?>">


                <?php echo $tabstr; ?>

            <div class='uport_contents'>

                <div data-contentid='1' id='uport1_content' class='uport_content active'>
                    <div class='tabcontent_wrap'>

                <table border=0 class='formtable'>
                    <tr>
                        <td class='tit'><span><?php _e('Item Title', 'uport-framework'); ?></td>
                        <td><input type="text" name="title" id="title" class="regular-text" value="<?php echo($item->item_title); ?>"></td>
                    </tr>
                    <tr><td class='tit'><span><?php _e('Description', 'uport-framework'); ?></td>
                        <td><textarea name="description" id="description"><?php echo($item->item_description); ?></textarea></td>
                    </tr>
                    <tr>
                        <td class='tit'><span><?php _e('Slug', 'uport-framework'); ?></td>
                        <td><input type="text" name="slug" id="slug" class="regular-text" value="<?php echo($item->item_slug); ?>"></td>
                    </tr>
                    <tr>
                        <td class='tit'><span><?php _e('Price', 'uport-framework'); ?></td>
                        <td><input type="text" name="price" id="price" class="regular-text" value="<?php echo($item->item_price); ?>"></td>
                    </tr>
                    <tr><td class='tit'><span><?php _e('URL Link', 'uport-framework'); ?></td>
                        <td><input type="text" name="link" id="link" class="regular-text" value="<?php echo($item->item_link); ?>">
                            <span class="descinfo"><?php _e('Add a URL to your item. If left empty no url button will be displayed', 'uport-framework'); ?></span>
                        </td>
                    </tr>
        <!--							<tr><td class='tit'><span><?php _e('Date', 'uport-framework'); ?></td>
                    <td><input type="text" name="date" id="date" value="<?php
                    if ($item->item_date == '0000-00-00') {
                        echo('');
                    } else {
                        echo(date("m/d/Y", strtotime($item->item_date)));
                    }
                    ?>"></td>
                    </tr>-->

                            <?php 
                                $catidstr = trim($item->item_category);
                                if(file_exists(plugin_dir_path( __FILE__ ).'../lib/uport-multicat-index.mc.php')){
                                    $catids = "0:Select (multi)|".uport_catstrs_ordered('str');
                                } else {
                                    $catids = "0:Select (multi)|".uport_catstrs('str');
                                }




                                $valarr = array("category" => $catidstr);
                                uport_field('Portfolio Categories', 'category', 'select_multi', '', $catids, 'Pick categories to display portfolio items from.', '1', $valarr, " uport-combobox-multi ");
                            ?>
</table>
                    </div>
                </div>


                <div data-contentid='2' id='uport2_content' class='uport_content '>
                    <div class='tabcontent_wrap'>


                    <table border=0 class='formtable'>
                    <tr><td class='tit'><span><?php _e('Preview Image', 'uport-framework'); ?></span></td>
                        <td><input type="text" name="thumbnail_adr" id="thumbnail_adr" class="regular-text" value="<?php echo($item->item_thumbnail); ?>" /><input type="button" name="thumbnail" id="thumbnail" class="uport-upload-but" value="<?php _e('Upload Image', 'uport-framework'); ?>" />
                            <div id="thumbnail_adr_area" class='upload-image-area'>
                                <?php if(isset($item->item_thumbnail) && trim($item->item_thumbnail) != ""){ ?>
                                <a href="<?php echo($item->item_thumbnail); ?>">
                                    <img src="<?php echo($item->item_thumbnail); ?>" alt="" width="400" height="auto" class="alignnone size-full">
                                </a>
                                <?php } ?>
                            </div>
                            <span class="descinfo"><?php _e('Image for preview purpose. This is the primary item image.', 'uport-framework'); ?></span>
                        </td>
                    </tr>
                    <tr><td class='tit'><span><?php _e('OR Embed Code in Preview', 'uport-framework'); ?></span></td>
                        <td><textarea name="thumbnailembed_adr" id="thumbnailembed_adr" class="regular-text"><?php echo stripslashes($item->item_thumbnailembed); ?></textarea>
                            <span class="descinfo"><?php _e('Use a small EMBED code like YouTube, Vimeo, Dailymotion, Instagram etc. embed codes. You can also embed AUDIO codes here.You will have to select Embed preview style (Video & Audio codes) for same while building your portfolio', 'uport-framework'); ?></span>
                    </td></tr>

                        </table>
                    </div>
                </div>


            <div data-contentid='3' id='uport3_content' class='uport_content '>
                <div class='tabcontent_wrap'>
                    <table border=0 class='formtable'>



                    <tr><td class='tit'><span><?php _e('Larger Image (for Lightbox)', 'uport-framework'); ?></span></td>
                        <td><input type="text" name="image_adr" id="image_adr" class="regular-text" value="<?php echo($item->item_image); ?>"/>
                            <input type="button" name="image" id="image" class="uport-upload-but" value="<?php _e('Upload Image', 'uport-framework'); ?>" />
                            <div id="image_adr_area" class='upload-image-area'>
                                <?php if(isset($item->item_image) && trim($item->item_image) != ""){ ?>
                                <a href="<?php echo($item->item_image); ?>">
                                    <img src="<?php echo($item->item_image); ?>" alt="" width="400" height="auto" class="alignnone size-full">
                                </a>
                                <?php } ?>
                            </div>
                            <span class="descinfo"><?php _e('This is the Image will be displayed when you show the item details in lightbox pop up. Leave blank to show the preview image.', 'uport-framework'); ?></span>
                        </td>
                    </tr>

                    <tr><td class='tit'><span><?php _e('Or External Video URL (for Lightbox)', 'uport-framework'); ?></span></td>
                        <td><input type="text" name="ext_adr" id="ext_adr" class="regular-text" value="<?php echo($item->item_ext); ?>"/>
                            
                            <span class="descinfo"><?php _e('Enter only URL. Do not embed code. The video type will be detected automatically. This is the Video will be displayed when you show the item details in lightbox. Eg: http://www.youtube.com/watch?v=6A9JVMLAQUk', 'uport-framework'); ?></span>
                        </td>
                    </tr>

                    <tr><td class='tit'><span><?php _e('Or Video URL (for Lightbox)', 'uport-framework'); ?></span></td>
                        <td><input type="text" name="extvideo_adr" id="extvideo_adr" class="regular-text" value="<?php echo($item->item_extvideo); ?>"/>
                            <input type="button" name="extvideourl" id="extvideourl" class="uport-upload-but" value="<?php _e('Upload Video', 'uport-framework'); ?>" />
                            <div id="extvideourl_area" class='upload-image-area'>
                                <?php if(isset($item->item_extvideo) && trim($item->item_extvideo) != ""){ ?>
                                <a href="<?php echo($item->item_extvideo); ?>">Video File</a>                                
                                <?php } ?>
                            </div>
                            <span class="descinfo"><?php _e('Enter only URL. Do not embed code here. The video type will be detected automatically. This is the video, will open up in lightbox using user browser&apos;s inbuilt video player. Eg: http://www.abcxyz.com/video.mp4', 'uport-framework'); ?></span>
                        </td>
                    </tr>
                    <tr><td class='tit'><span><?php _e('Or Audio URL (for Lightbox)', 'uport-framework'); ?></span></td>
                        <td><input type="text" name="extaudio_adr" id="extaudio_adr" class="regular-text"  value="<?php echo($item->item_extaudio); ?>"/>
                            <input type="button" name="extaudiourl" id="extaudiourl" class="uport-upload-but" value="<?php _e('Upload Audio', 'uport-framework'); ?>" />
                            <div id="extaudiourl_area" class='upload-image-area'>
                                <?php if(isset($item->item_extaudio) && trim($item->item_extaudio) != ""){ ?>
                                <a href="<?php echo($item->item_extaudio); ?>">Audio File</a>
                                <?php } ?>
                            </div>
                            <span class="descinfo"><?php _e('Enter only URL. Do not embed code here. The audio type will be detected automatically. This is the audio will open up in lightbox using user browser&apos;s inbuilt audio player. Eg: http://www.abcxyz.com/audio.mp3', 'uport-framework'); ?></span>
                        </td>
                    </tr>
                    <tr><td class='tit'><span><?php _e('Or EMBED HTML CODE (for Lightbox)', 'uport-framework'); ?></span></td>
                        <td><textarea name="extembed_adr" id="extembed_adr" class="regular-text" /><?php echo stripslashes($item->item_extembed); ?></textarea>
                            
                            <span class="descinfo"><?php _e('Enter your EMBED CODE. This code can be a video embeded code, embeded audio code or any HTML code. It will be displayed in Lightbox', 'uport-framework'); ?></span>
                        </td>
                    </tr>

                        <?php
                            $valarr = array( "exttype_adr" => $item->item_exttype);
                            uport_field('Lightbox Media Type', 'exttype_adr', 'select', 'none', $lightbox_mediatype, 'Please pick the type of your lightbox media of item. Eg: video or image or any other', '1', $valarr, "");
                        ?>

                        </table>
                    </div>
                </div>
        </div>

                            <input type="hidden" name="item_id" id="item_id" value="<?php echo($item_id); ?>"/>
                            <input type="hidden" name="which" id="which" value="update_item"/>
                            <input type="submit" value="<?php _e('Save Item', 'uport-framework'); ?>" class="savebut1">
            </form>
        </div> <!-- .wrap -->
        <?php
    }
}

function uport_get_new_item_page_insert() {
    global $wpdb;

        $currenttime = time();

    if ($_POST['which'] == 'new_item') {

        //print_r($_POST);
        $item_title = $_POST['title'];
        $item_link = $_POST['link'];
        $item_category = $_POST['uport_category'];
        $item_slug = $_POST['slug'];
        $item_price = $_POST['price'];
        $item_date = "";
        $item_thumbnail = $_POST['thumbnail_adr'];
        $item_thumbnailembed = $_POST['thumbnailembed_adr'];
        $item_image = $_POST['image_adr'];
        $item_ext = $_POST['ext_adr'];
        $item_extvideo = $_POST['extvideo_adr'];
        $item_extaudio = $_POST['extaudio_adr'];
        $item_extembed = $_POST['extembed_adr'];
        $item_exttype = $_POST['uport_exttype_adr'];
        $item_description = $_POST['description'];
        $item_date = $currenttime;

        $wpdb->query($wpdb->prepare('
	INSERT INTO ' . $wpdb->prefix . 'uport_items(item_title, item_link, item_description, item_slug, item_date, item_thumbnail, item_thumbnailembed, item_image, item_ext, item_extvideo, item_extaudio, item_extembed, item_category, item_exttype, item_price)
	VALUES( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)', $item_title, $item_link, $item_description, $item_slug, $item_date, $item_thumbnail, $item_thumbnailembed, $item_image, $item_ext, $item_extvideo, $item_extaudio, $item_extembed, $item_category, $item_exttype, $item_price));
    }
}

function uport_get_new_item_page_update() {
    global $wpdb;

        $currenttime = time();
    
    if ($_POST['which'] == 'update_item') {
        $item_id = $_POST['item_id'];
        $item_title = $_POST['title'];
        $item_link = $_POST['link'];
        $item_category = $_POST['uport_category'];
        $item_slug = $_POST['slug'];
        $item_price = $_POST['price'];
        $item_date = "";
        $item_thumbnail = $_POST['thumbnail_adr'];
        $item_thumbnailembed = $_POST['thumbnailembed_adr'];
        $item_image = $_POST['image_adr'];
        $item_ext = $_POST['ext_adr'];
        $item_extvideo = $_POST['extvideo_adr'];
        $item_extaudio = $_POST['extaudio_adr'];
        $item_extembed = $_POST['extembed_adr'];
        $item_date = $currenttime;
        $item_exttype = $_POST['uport_exttype_adr'];
        $item_description = $_POST['description'];

     
        $wpdb->query($wpdb->prepare('UPDATE ' . $wpdb->prefix . 'uport_items SET 
                    item_title = \'' . $item_title . '\', 
                    item_link =\'' . $item_link . '\', 
                    item_description =\'' . $item_description . '\', 
                    item_slug =\'' . $item_slug . '\', 
                    item_date =\'' . $item_date . '\', 
                    item_thumbnail =\'' . $item_thumbnail . '\', 
                    item_thumbnailembed =\'' . $item_thumbnailembed . '\', 
                    item_image =\'' . $item_image . '\', 
                    item_ext =\'' . $item_ext . '\', 
                    item_extaudio =\'' . $item_extaudio . '\', 
                    item_extvideo =\'' . $item_extvideo . '\', 
                    item_exttype =\'' . $item_exttype . '\', 
                    item_price =\'' . $item_price . '\', 
                    item_category =\'' . $item_category . '\' 
                WHERE item_id = %d ', $item_id));

        $wpdb->query($wpdb->prepare(' UPDATE ' . $wpdb->prefix . 'uport_items SET item_extembed = %s WHERE item_id = %d ', $item_extembed, $item_id));
    }
}

function uport_get_potfolio_items_page() {
    global $wpdb;
    $printdata = "";  
    ?>
    <div class="wrap">
        <h2 class='uport_head'><?php _e('Items ', 'uport-framework'); ?><a href="<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_add_new_item" title="" class="add-new-h2"><?php _e('Add New', 'uport-framework'); ?></a></h2>
        <?php
        echo "<span class='uport_msg'></span>";

        $items = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'uport_items');
        if ($items == null) {
            echo(__('You don\'t have any item.', 'uport-framework') . '&nbsp;' . __('Please', 'uport-framework') . '&nbsp;<a href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_item" title="">' . __('Add a New Item', 'uport-framework') . '</a>');
        } else {
            ?>
            <table border=0 cellspacing=0 cellpadding=0 class='viewtable viewtable-item'>
                <tr>
                    <td style="width:5%"><?php _e('ID', 'uport-framework'); ?></td>
                    <td style="width:10%" class="bgimg"><?php _e('Thumbnail', 'uport-framework'); ?></td>
                    <td style="width:20%" ><?php _e('Title', 'uport-framework'); ?></td>
                    <td style="width:12%" ><?php _e('Category', 'uport-framework'); ?></td>
                    <td style="width:15%" ><?php _e('Actions', 'uport-framework'); ?></td>
                    <td style='width:8%'><input type='checkbox' class='uportallrow' name='uportallrow' id='uportallrow'/>&nbsp;<?php _e('Select', 'uport-framework'); ?></td>
                </tr>
                <?php
                foreach ($items as $item) {

                    $catids = uport_catstrs('arr');
                    $catstr = array_unique(array_filter(explode("|", $item->item_category)));
                    $str = "";
                    foreach ($catstr as $catid) {
                        if (isset($catids[$catid]) && trim($catids[$catid]) != "") {
                            $str .= $catids[$catid] . ", ";
                        }
                    }
                    $str = substr($str, 0, -2);

                    $db_thumbnail = $item->item_thumbnail;
                    $item->item_thumbnail = uport_upload_url($item->item_thumbnail);                    
                    $ori_image = $item->item_thumbnail;

                    // if empty return url then use original
                    $thumbimage = aq_uport_resize($ori_image, "60","60",true);
                    if (trim($thumbimage) == "" || trim($thumbimage) == false) {
                        $thumbimage = $ori_image;
                    }


                    echo('<tr><td>' . $item->item_id . '</td>
					<td class="bgimg"><a href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_item&item_id=' . $item->item_id . '"><div style="background: url(' . $thumbimage. ') center; background-size: cover; width: 60px; height: 60px;margin:10px 0;"></div></a></td>
					<td><a href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_item&item_id=' . $item->item_id . '">' . __($item->item_title, 'uport-framework') . '</a></td>
					<td>' . __($str, 'uport-framework') . '</td>
					<td class="actions">
					<a class="edit" href="' . home_url() . '/wp-admin/admin.php?page=uport_add_new_item&item_id=' . $item->item_id . '">'.__("Edit", 'uport-framework').'</a>
					<a class="smallbutton delete" href="javascript:;" onclick=\'uport_actionthis("' . esc_url(add_query_arg(array("page" => "uport_items_page"))) . '","' . $item->item_id . '","del_item")\' >'.__("Del", 'uport-framework').'</a>
                    <a class="smallbutton copy" href="javascript:;" onclick=\'uport_actionthis("' . esc_url(add_query_arg(array("page" => "uport_items_page"))) . '","' . $item->item_id . '","copy_item")\' >'.__("Copy", 'uport-framework').'</a>
					</td>

                    <td align="right" class="selectrow">
                    <input type="checkbox" class="uportrow" name="uportrow" id="uportrow_'.$item->item_id.'" data-id="'.$item->item_id.'" value="'.$item->item_id.'" data-type="portfolio"/>
                    </td>
				</tr>');

                }
                ?>
            </table>
            <?php

            echo "<div class='selactions_wrap'><button class='deletesel uport_selactions' disabled href='javascript:;' data-type='item' data-action='delete' >".__('Delete Selected', 'uport-framework')."</button>
        <button class='copysel uport_selactions' disabled href='javascript:;' data-type='item' data-action='copy' >".__('Copy Selected', 'uport-framework')."</button></div>";
        }
    }
    ?>