<?php

function uport_reload_live_preview() {
    if (!isset($_POST['uport_nonce']) || !wp_verify_nonce($_POST['uport_nonce'], 'uport-nonce')) {
        die('Permissions check failed. Please login or refresh (if already logged in) the page, then try Again.');
    }

    if (isset($_POST['id']) && trim($_POST['id']) != "") {
        $id = $_POST['id'];
        echo uport_shortcode_display($id, 'ajax');
    } else {
        
    }

    die();
}

function uport_live_preview($id) {
    echo "<h3>Live Preview</h3><form action='javascript:void();' class='formwrap'>";
    echo "<div class='live_preview_wrapper'>";
    echo "<div id='uport_loadit' class='load_live_preview'></div>";
    echo "<div id='uport_live_result'>";

    if (isset($_GET['id']) && trim($_GET['id']) != "") {
        echo uport_shortcode_display($id);
    } else {
        echo "<span class='uport_alert_msg'>No valid Portfolio ID found. Please Save a Section to load live preview.</span>";
    }

    echo "</div>";

    echo "</div>";
    echo "</form>";
}

add_action('wp_ajax_uport_load_live_preview', 'uport_display_live_preview');
add_action('wp_ajax_uport_reload_live_preview', 'uport_reload_live_preview');

function uport_display_live_preview() {

    if (!isset($_POST['uport_nonce']) || !wp_verify_nonce($_POST['uport_nonce'], 'uport-nonce')) {
        die('Permissions check failed. Please login or refresh (if already logged in) the page, then try Again.');
    }

    $effcss = $_POST['effcss'];
    $gtype = $_POST['gtype'];
    $pid = $_POST['pid'];
    $id = $_POST['id'];
    $values = $_POST['values'];
    $type = $_POST['type'];

    include(plugin_dir_path( __FILE__ )."../shortcode/uport-def-values.php");

    if (trim($values) != "") {
        $starexp = explode("&", $values);
        foreach ($starexp as $metas) {
            if (trim($metas) != "") {
                $expmeta = explode("=", $metas);
                $arr[$expmeta[0]] = urldecode($expmeta[1]);
            }
        }
    }

    $val3arr = $arr;

    $autopxs = uport_nonautopxs();
    foreach ($val3arr as $k => $v) {
        if (!in_array($k, $autopxs) && is_numeric($v)) {
            $val3arr[$k] = trim($v) . "px";
        }
    }

    $val2arr = array();
    $stylestr = uport_common_css($pid, $val2arr, $val3arr, '0', $gtype, $type, $effcss);
    $stylestr = uport_compress_css($stylestr);
    //echo $stylestr;



    echo "<script type='text/javascript'>
		if($('#" . $pid . "-" . $type . "-style').length > 0){		
			$('#" . $pid . "-" . $type . "-style').html('" . $stylestr . "'); 
		}

		if($('#" . $pid . "-" . $effcss . $type . "-style').length > 0){		
			$('#" . $pid . "-" . $effcss . $type . "-style').html('" . $stylestr . "'); 
		}

	</script>";

    die();
}

function uport_compress_css($css) {
    /* remove comments */
    $css = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);

    /* remove tabs, spaces, newlines, etc. */
    $css = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css);
    return $css;
}

?>