<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
function uport_items_page_menu() {
    add_menu_page('Ultra Portfolio', __('Ultra Portfolio', 'uport-framework'), 'manage_options', 'uport', 'uport_portfolio_list');

    add_submenu_page('uport', 'New Portfolio', __('New Portfolio', 'uport-framework'), 'manage_options', 'uport_edit_portfolio', 'uport_panel_steps');
    add_submenu_page('uport', 'Items list', __('Items list', 'uport-framework'), 'manage_options', 'uport_items_page', 'uport_items_page');
}

function uport_add_new_portfolio() {
    
}

function uport_add_new_page_menu() {
    add_submenu_page('uport', 'Add New Item', __('Add New Item', 'uport-framework'), 'manage_options', 'uport_add_new_item', 'uport_add_new_page');
}

function uport_categories_page_menu() {
    add_submenu_page('uport', 'Categories List', __('Categories List', 'uport-framework'), 'manage_options', 'uport_categories', 'uport_categories_page');
}

function uport_add_new_category_page_menu() {
    add_submenu_page('uport', 'Add New Category', __('Add New Category', 'uport-framework'), 'manage_options', 'uport_add_new_category', 'uport_add_new_category_page');
}

function uport_install_demos_menu() {
    add_submenu_page('uport', 'Install Demos', __('Install Demos', 'uport-framework'), 'manage_options', 'uport_install_demos', 'uport_install_demos_page');
}

function uport_menu_action() {
    add_action('admin_menu', 'uport_items_page_menu');
    add_action('admin_menu', 'uport_add_new_portfolio');
    add_action('admin_menu', 'uport_add_new_page_menu');
    add_action('admin_menu', 'uport_categories_page_menu');
    add_action('admin_menu', 'uport_add_new_category_page_menu');
    add_action('admin_menu', 'uport_install_demos_menu');
}

add_action('plugins_loaded', 'uport_menu_action');
?>