<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
function uport_common_selector($pid, $gtype, $effcss, $uporttype) {


    $uport_g1_selector = array();
    $uport_g1_selector['title'] = ".uport-view-" . $pid . " h2, .uport-view-" . $pid . " h2 a, .uport-view-" . $pid . " .outarea h2, .uport-view-" . $pid . " .outarea h2 a";
    $uport_g1_selector['slug'] = ".uport-view-" . $pid . " h4, .uport-view-" . $pid . " .outarea h4";
    $uport_g1_selector['desc'] = ".uport-view-" . $pid . " p, .uport-view-" . $pid . " .outarea p";
    $uport_g1_selector['but'] = ".uport-view-" . $pid . " a.info, .uport-view-" . $pid . " .outarea a.info, .uport-view-" . $pid . " .above-wrapper a.info";
    $uport_g1_selector['buthover'] = ".uport-view-" . $pid . " a.info:hover, .uport-view-" . $pid . " .outarea a.info:hover, .uport-view-" . $pid . " .above-wrapper a.info:hover";
    $uport_g1_selector['catul'] = ".uport-cats-" . $pid . "";
    $uport_g1_selector['catli'] = ".uport-cats-" . $pid . " a, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page span";
    $uport_g1_selector['catlihover'] = ".uport-cats-" . $pid . " a:hover, .uport-cats-" . $pid . " a.active, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page.active span";
    $uport_g1_selector['maskbg'] = ".uport-view-" . $pid . " .mask";
    $uport_g1_selector['item'] = ".uport-view-" . $pid . "";
    $uport_g1_selector['border'] = ".uport-view-" . $pid . " .item-wrapper ";
    $uport_g1_selector['shadow'] = ".uport-view-" . $pid . " .item-wrapper ";
    $uport_g1_selector['price'] = ".uport-view-" . $pid . " .price, .uport-view-" . $pid . " .outarea .price, .uport-view-" . $pid . " .above-wrapper .price";
    $uport_g1_selector['responsive'] = ".uport-view-" . $pid . "";
    $uport_g1_selector['wrapper'] = ".uport-wrapper-" . $pid . "";
    $uport_g1_selector['wrappercatul'] = ".uport-cats-" . $pid . "";
    $uport_g1_selector['area'] = ".uport-wrapout-" . $pid . "";
    $uport_g1_selector['outbg'] = ".uport-view-" . $pid . " .item-wrapper";
    $uport_g1_selector['portbg'] = ".uport-wrapout-" . $pid . "";
    $uport_g1_selector['above'] = ".uport-view-" . $pid . " .above-wrapper";


    $uport_g2_selector = array();
    $uport_g2_selector['title'] = ".uport-grid-" . $pid . " figcaption h4, .uport-grid-" . $pid . " figcaption h4 a, .uport-grid-" . $pid . " .outarea h4, .uport-grid-" . $pid . " .outarea h4 a";
    $uport_g2_selector['slug'] = ".uport-grid-" . $pid . " figcaption span.txt, .uport-grid-" . $pid . " .outarea span.txt";
    $uport_g2_selector['desc'] = ".uport-grid-" . $pid . " figcaption p, .uport-grid-" . $pid . " .outarea p";
    $uport_g2_selector['but'] = ".uport-grid-" . $pid . " figcaption a.info, .uport-grid-" . $pid . " .outarea a.info, .uport-grid-" . $pid . " .above-wrapper a.info";
    $uport_g2_selector['buthover'] = ".uport-grid-" . $pid . " figcaption a.info:hover, .uport-grid-" . $pid . " .outarea a.info:hover, .uport-grid-" . $pid . " .above-wrapper a.info:hover";
    $uport_g2_selector['catul'] = ".uport-cats-" . $pid . "";
    $uport_g2_selector['catli'] = ".uport-cats-" . $pid . " a, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page span";
    $uport_g2_selector['catlihover'] = ".uport-cats-" . $pid . " a:hover, .uport-cats-" . $pid . " a.active, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page.active span";
    $uport_g2_selector['maskbg'] = ".uport-grid-" . $pid . " figcaption";
    $uport_g2_selector['item'] = ".uport-view-" . $pid . "";
    $uport_g2_selector['border'] = ".uport-view-" . $pid . " .item-wrapper ";
    $uport_g2_selector['shadow'] = ".uport-view-" . $pid . " .item-wrapper ";
    $uport_g2_selector['price'] = ".uport-grid-" . $pid . " figcaption .price, .uport-grid-" . $pid . " .outarea .price, .uport-grid-" . $pid . " .above-wrapper .price";
    $uport_g2_selector['responsive'] = ".uport-view-" . $pid . "";
    $uport_g2_selector['wrapper'] = ".uport-wrapper-" . $pid . "";
    $uport_g2_selector['wrappercatul'] = ".uport-cats-" . $pid . "";
    $uport_g2_selector['area'] = ".uport-wrapout-" . $pid . "";
    $uport_g2_selector['outbg'] = ".uport-grid-" . $pid . " .item-wrapper";
    $uport_g2_selector['portbg'] = ".uport-wrapout-" . $pid . "";
    $uport_g2_selector['above'] = ".uport-grid-" . $pid . " .above-wrapper";


    $uport_g3_selector = array();
    $uport_g3_selector['title'] = ".uport-" . $effcss . "-" . $pid . " .ch-info h4, .uport-" . $effcss . "-" . $pid . " .ch-info h4 a, .uport-" . $effcss . "-" . $pid . " .outarea h4, .uport-" . $effcss . "-" . $pid . " .outarea h4 a";
    $uport_g3_selector['slug'] = ".uport-" . $effcss . "-" . $pid . " .ch-info span.txt, .uport-" . $effcss . "-" . $pid . " .outarea span.txt";
    $uport_g3_selector['desc'] = ".uport-" . $effcss . "-" . $pid . " .ch-info p, .uport-" . $effcss . "-" . $pid . " .outarea p";
    $uport_g3_selector['but'] = ".uport-" . $effcss . "-" . $pid . " .ch-info a.info, .uport-" . $effcss . "-" . $pid . " .outarea a.info, .uport-" . $effcss . "-" . $pid . " .above-wrapper a.info";
    $uport_g3_selector['buthover'] = ".uport-" . $effcss . "-" . $pid . " .ch-info a.info:hover, .uport-" . $effcss . "-" . $pid . " .outarea a.info:hover, .uport-" . $effcss . "-" . $pid . " .above-wrapper a.info:hover";
    $uport_g3_selector['catul'] = ".uport-cats-" . $pid . "";
    $uport_g3_selector['catli'] = ".uport-cats-" . $pid . " a, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page span";
    $uport_g3_selector['catlihover'] = ".uport-cats-" . $pid . " a:hover, .uport-cats-" . $pid . " a.active, .uport-wrapper-" . $pid . " .owl-theme .owl-controls .owl-page.active span";
    $uport_g3_selector['price'] = ".uport-" . $effcss . "-" . $pid . " .ch-info .price, .uport-" . $effcss . "-" . $pid . " .outarea .price, .uport-" . $effcss . "-" . $pid . " .above-wrapper .price";
    $uport_g3_selector['responsive'] = ".uport-" . $effcss . "-" . $pid . " li";
    $uport_g3_selector['wrapper'] = ".uport-wrapper-" . $pid . "";
    $uport_g3_selector['wrappercatul'] = ".uport-cats-" . $pid . "";
    $uport_g3_selector['area'] = ".uport-wrapout-" . $pid . "";
    $uport_g3_selector['outbg'] = ".uport-" . $effcss . "-" . $pid . " .item-wrapper";
    $uport_g3_selector['portbg'] = ".uport-wrapout-" . $pid . "";
    $uport_g3_selector['above'] = ".uport-" . $effcss . "-" . $pid . " .above-wrapper";


    $uport_g3_selector['effect21maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info";
    $uport_g3_selector['effect21item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect21border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect21shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect22maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info";
    $uport_g3_selector['effect22item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect22border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect22shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect23maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info";
    $uport_g3_selector['effect23item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect23border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect23shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect24maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info .ch-info-back";
    $uport_g3_selector['effect24item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect24border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect24shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect25maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info .ch-info-back";
    $uport_g3_selector['effect25item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect25border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect25shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect26maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-item:hover .ch-info-back";
    $uport_g3_selector['effect26item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect26border'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect26shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";

    $uport_g3_selector['effect27maskbg'] = ".uport-" . $effcss . "-" . $pid . " .ch-info .ch-info-back";
    $uport_g3_selector['effect27item'] = ".uport-" . $effcss . "-" . $pid . " .ch-item";
    $uport_g3_selector['effect27border'] = ".uport-" . $effcss . "-" . $pid . " .ch-info-front";
    $uport_g3_selector['effect27shadow'] = ".uport-" . $effcss . "-" . $pid . " .ch-info-front";




    if ($gtype == "g1") {
        return $uport_g1_selector;
    } else if ($gtype == "g2") {
        return $uport_g2_selector;
    } else if ($gtype == "g3") {
        return $uport_g3_selector;
    } else {
        return "";
    }
}

function uport_common_property($val2arr, $val3arr, $ele) {

    $property = "";
    if ($ele == "title") {
        $property = uport_common_css_h($val3arr);
    }
    if ($ele == "slug") {
        $property = uport_common_css_slug($val3arr);
    }
    if ($ele == "desc") {
        $property = uport_common_css_desc($val3arr);
    }
    if ($ele == "but") {
        $property = uport_common_css_but($val3arr);
    }
    if ($ele == "buthover") {
        $property = uport_common_css_buthover($val3arr);
    }
    if ($ele == "catul") {
        $property = uport_common_css_catul($val2arr, $val3arr);
    }
    if ($ele == "catli") {
        $property = uport_common_css_catli($val3arr);
    }
    if ($ele == "catlihover") {
        $property = uport_common_css_catlihover($val3arr);
    }
    if ($ele == "maskbg") {
        $property = uport_common_css_maskbg($val3arr);
    }
    if ($ele == "outbg") {
        $property = uport_common_css_outbg($val3arr);
    }
    if ($ele == "portbg") {
        $property = uport_common_css_portbg($val3arr);
    }
    if ($ele == "item") {
        $property = uport_common_css_item($val3arr);
    }
    if ($ele == "border") {
        $property = uport_common_css_border($val3arr);
    }
    if ($ele == "shadow") {
        $property = uport_common_css_shadow($val3arr);
    }
    if ($ele == "price") {
        $property = uport_common_css_price($val3arr);
    }
    if ($ele == "above") {
        $property = uport_common_css_above($val3arr);
    }
    if ($ele == "wrapper") {
        $property = uport_common_css_wrapper($val2arr,$val3arr);
    }
    if ($ele == "wrappercatul") {
        $property = uport_common_css_wrappercatul($val2arr,$val3arr);
    }
    if ($ele == "area") {
        $property = uport_common_css_area($val2arr,$val3arr);
    }

    $effectmaskbg = array("effect21maskbg", "effect22maskbg", "effect23maskbg", "effect24maskbg", "effect25maskbg", "effect26maskbg", "effect27maskbg");
    if (in_array($ele, $effectmaskbg)) {
        $property = uport_common_css_maskbg($val3arr);
    }

    $effectitem = array("effect21item", "effect22item", "effect23item", "effect24item", "effect25item", "effect26item", "effect27item");
    if (in_array($ele, $effectitem)) {
        $property = uport_common_css_item($val3arr);
    }

    $effectborder = array("effect21border", "effect22border", "effect23border", "effect24border", "effect25border", "effect26border", "effect27border");
    if (in_array($ele, $effectborder)) {
        $property = uport_common_css_border($val3arr);
    }

    $effectshadow = array("effect21shadow", "effect22shadow", "effect23shadow", "effect24shadow", "effect25shadow", "effect26shadow", "effect27shadow");
    if (in_array($ele, $effectshadow)) {
        $property = uport_common_css_shadow($val3arr);
    }

    return $property;
}

function uport_common_css($pid, $val2arr, $val3arr, $styletag = "0", $gtype, $ele, $effcss = "") {


    $selector = uport_common_selector($pid, $gtype, $effcss, $val2arr['uporttype']);


    if ($ele == "responsive") {

        $str = uport_responsive_style($pid, $val2arr, $val3arr, $ele, $selector, $val2arr['uporttype']);
    } else {

        $property = uport_common_property($val2arr, $val3arr, $ele);

        if ($selector[$ele] == "") {
            // like effect21maskbg  cases
            $effcss_ele = $effcss . $ele;
            $str = "" . $selector[$effcss_ele] . "{" . $property . "}";
        } else {
            $str = "" . $selector[$ele] . "{" . $property . "}";
        }
    }

    if ($styletag == "1") {
        $str = "<style type='text/css' id='" . $pid . "-" . $ele . "-style'>" . $str . "</style>\n";
    }

    return $str;
}




function uport_common_css_area($val2arr,$val3arr) {

    $ret = "width:100%;";

    if($val2arr['uporttype'] == "single" || $val2arr['uporttype'] == "slider"){
        $ret .= "overflow-x:hidden;overflow-y: visible;";
    }


    $minwidth = $maxwidth = '100%';

    if (isset($val2arr['minwidth']) && trim($val2arr['minwidth']) != "") {
        $minwidth = trim($val2arr['minwidth']);
    }

    if (isset($val2arr['maxwidth']) && trim($val2arr['maxwidth']) != "") {
        $maxwidth = trim($val2arr['maxwidth']);
    }

    if (is_numeric($minwidth)) {
        $minwidth = trim($minwidth) . "px";
    }

    if (is_numeric($maxwidth)) {
        $maxwidth = trim($maxwidth) . "px";
    }

    $ret .= "min-width: " . trim($minwidth) . ";";
    $ret .= "max-width: " . trim($maxwidth) . ";";

    return $ret;

}

function uport_common_css_wrapper($val2arr,$val3arr) {
    $ret = "";
    $left = $right = 0;

    if (isset($val2arr['marginleft']) && trim($val2arr['marginleft']) != "") {
        $left = trim($val2arr['marginleft']);
    }
    if (isset($val2arr['marginright']) && trim($val2arr['marginright']) != "") {
        $right = trim($val2arr['marginright']);
    }

    if (is_numeric($left)) {
        $left = trim($left) . "px";
    }
    if (is_numeric($right)) {
        $right = trim($right) . "px";
    }

    $ret = "margin-left: -" . trim($left) . ";";
    $ret .= "margin-right: -" . trim($right) . ";";

    return $ret;

}

function uport_responsive_style($pid, $val2arr, $val3arr, $ele, $selector, $uporttype) {

    $ret = "";

    $col1 = uport_common_css_responsive($val2arr, $val3arr, 'noofcolumns1', $uporttype);
    $col2 = uport_common_css_responsive($val2arr, $val3arr, 'noofcolumns2', $uporttype);
    $col3 = uport_common_css_responsive($val2arr, $val3arr, 'noofcolumns3', $uporttype);
    $col4 = uport_common_css_responsive($val2arr, $val3arr, 'noofcolumns4', $uporttype);

    $ret .= "" . $selector[$ele] . "{" . $col1 . ";height: auto;} ";
    $ret .= "@media (min-width:1200px){" . $selector[$ele] . "{" . $col1 . ";height: auto;}" . "} ";
    $ret .= "@media (max-width:1024px){" . $selector[$ele] . "{" . $col2 . ";height: auto;}" . "} ";
    $ret .= "@media (max-width:800px){" . $selector[$ele] . "{" . $col3 . ";height: auto;}" . "} ";
    $ret .= "@media (max-width:400px){" . $selector[$ele] . "{" . $col4 . ";height: auto;}" . "} ";

    return $ret;
}

function uport_common_css_responsive($val2arr, $val3arr, $type, $uporttype) {

    $top = $left = $right = $bottom = 0;

    if (isset($val2arr['margintop']) && trim($val2arr['margintop']) != "") {
        $top = trim($val2arr['margintop']);
    }
    if (isset($val2arr['marginleft']) && trim($val2arr['marginleft']) != "") {
        $left = trim($val2arr['marginleft']);
    }
    if (isset($val2arr['marginright']) && trim($val2arr['marginright']) != "") {
        $right = trim($val2arr['marginright']);
    }
    if (isset($val2arr['marginbottom']) && trim($val2arr['marginbottom']) != "") {
        $bottom = trim($val2arr['marginbottom']);
    }

    if (is_numeric($top)) {
        $top = trim($top) . "px";
    }
    if (is_numeric($left)) {
        $left = trim($left) . "px";
    }
    if (is_numeric($right)) {
        $right = trim($right) . "px";
    }
    if (is_numeric($bottom)) {
        $bottom = trim($bottom) . "px";
    }

    $col = trim($val2arr[$type]);
    $width = (100 / $col);

    $str = "";

    if ($uporttype == "slider" || $uporttype == "single") {
        $width = $width - $left - $right;
        $str = "margin: " . $top . "  " . $right . "  " . $bottom . "  " . $left . " !important;";
    } else {
        $str = "padding: " . $top . "  " . $right . "  " . $bottom . "  " . $left . " !important;";
        $str .= "width:  " . $width . "% ;min-width:  " . $width . "% ;max-width:  " . $width . "% ;";
    }
    return $str;
}

function uport_common_css_wrappercatul($val2arr, $val3arr) {
    ob_start();
    echo "margin:0px;padding:0px;";

    $left = $right = 0;

    if (isset($val2arr['marginleft']) && trim($val2arr['marginleft']) != "") {
        $left = trim($val2arr['marginleft']);
    }
    if (isset($val2arr['marginright']) && trim($val2arr['marginright']) != "") {
        $right = trim($val2arr['marginright']);
    }

    if (is_numeric($left)) {
        $left = trim($left) . "px";
    }
    if (is_numeric($right)) {
        $right = trim($right) . "px";
    }

    echo "margin-left: " . trim($left) . ";";
    echo "margin-right: " . trim($right) . ";";
    return ob_get_clean();

}

function uport_common_css_catul($val2arr, $val3arr) {

    ob_start();
    if (trim($val3arr['catalign']) == "center") {
        echo "float:none;text-align:center;display:block;width:100%;";
    }
    if (trim($val3arr['catalign']) == "left") {
        echo "float:left;";
    }
    if (trim($val3arr['catalign']) == "right") {
        echo "float:right;";
    }
    if (trim($val2arr['catshow']) == "show") {
        echo "display:block;";
    }
        //echo "uporttype:".$val2arr['uporttype'].";";

    ?>
    box-sizing:border-box;
    -moz-box-sizing:border-box;
    -ms-box-sizing:border-box;
    -o-box-sizing:border-box;
    -webkit-box-sizing:border-box;
    <?php
    return ob_get_clean();
}

function uport_common_css_catli($val3arr) {
    ob_start();
    echo uport_common_font('cat',$val3arr);
    ?>
    text-decoration:none;
    margin:0 auto;
    position:relative;
    display: inline-block;
    text-align:center;
    color: <?php echo trim($val3arr['catcolor']); ?>;
    background: <?php echo trim($val3arr['catbgcolor']); ?>;
    padding: <?php echo trim($val3arr['catpaddingtop']); ?> <?php echo trim($val3arr['catpaddingright']); ?> <?php echo trim($val3arr['catpaddingbottom']); ?> <?php echo trim($val3arr['catpaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['catmargintop']); ?> <?php echo trim($val3arr['catmarginright']); ?> <?php echo trim($val3arr['catmarginbottom']); ?> <?php echo trim($val3arr['catmarginleft']); ?> ;
    border: <?php echo trim($val3arr['catborderwidth']); ?> solid <?php echo trim($val3arr['catbordercolor']); ?>;
    border-radius: <?php echo trim($val3arr['catborderradius']); ?>;
    -webkit-border-radius: <?php echo trim($val3arr['catborderradius']); ?>;
    -moz-border-radius: <?php echo trim($val3arr['catborderradius']); ?>;
    -o-border-radius: <?php echo trim($val3arr['catborderradius']); ?>;
    -ms-border-radius: <?php echo trim($val3arr['catborderradius']); ?>;
    cursor:hand;cursor:pointer;
    <?php
    return ob_get_clean();
}

function uport_common_css_catlihover($val3arr) {
    ob_start();
    ?>
    background: <?php echo trim($val3arr['catbgactcolor']); ?>;
    text-decoration:none;
    color: <?php echo trim($val3arr['catcolor']); ?>;
    <?php
    return ob_get_clean();
}

function uport_common_css_item($val3arr) {
    ob_start();
    ?>
    box-sizing:border-box;-moz-box-sizing:border-box;-ms-box-sizing:border-box;-o-box-sizing:border-box;-webkit-box-sizing:border-box;
    <?php
    return ob_get_clean();
}

function uport_common_css_border($val3arr) {
    ob_start();
    ?>
    border: <?php echo trim($val3arr['borderwidth']); ?> solid <?php echo trim($val3arr['bordercolor']); ?>;
    <?php
    return ob_get_clean();
}

function uport_common_css_shadow($val3arr) {
    ob_start();
    ?>
    -webkit-box-shadow: <?php echo trim($val3arr['hshadow']); ?> <?php echo trim($val3arr['vshadow']); ?> <?php echo trim($val3arr['shadowblur']); ?> <?php echo trim($val3arr['shadowspread']); ?> <?php echo trim($val3arr['shadowcolor']); ?>;
    -moz-box-shadow: <?php echo trim($val3arr['hshadow']); ?> <?php echo trim($val3arr['vshadow']); ?> <?php echo trim($val3arr['shadowblur']); ?> <?php echo trim($val3arr['shadowspread']); ?> <?php echo trim($val3arr['shadowcolor']); ?>;
    box-shadow: <?php echo trim($val3arr['hshadow']); ?> <?php echo trim($val3arr['vshadow']); ?> <?php echo trim($val3arr['shadowblur']); ?> <?php echo trim($val3arr['shadowspread']); ?> <?php echo trim($val3arr['shadowcolor']); ?>;
    -o-box-shadow: <?php echo trim($val3arr['hshadow']); ?> <?php echo trim($val3arr['vshadow']); ?> <?php echo trim($val3arr['shadowblur']); ?> <?php echo trim($val3arr['shadowspread']); ?> <?php echo trim($val3arr['shadowcolor']); ?>;
    -ms-box-shadow: <?php echo trim($val3arr['hshadow']); ?> <?php echo trim($val3arr['vshadow']); ?> <?php echo trim($val3arr['shadowblur']); ?> <?php echo trim($val3arr['shadowspread']); ?> <?php echo trim($val3arr['shadowcolor']); ?>;
    <?php
    return ob_get_clean();
}


function uport_common_font($type,$val3arr){

    $str = "";

    /*family*/    
    $family = "";
    $gfont = $val3arr[$type.'fontname'];
    $backup = $val3arr[$type.'fontbackup'];
    $family .= trim($gfont);
    if($family != "" && trim($backup) != ""){ $family .= ",";}
    $family .= trim($backup);

    /*line height*/
    $lineheight = trim($val3arr[$type.'lineheight']);

    /*size*/
    $size = trim($val3arr[$type.'fontsize']); 

    /*weight*/
    $weight = trim($val3arr[$type.'fontweight']);
    preg_match_all('!\d+!', $weight, $matches);

    $str .= "font-family:".$family.";";
    $str .= "font-weight:".$matches[0][0].";";
    $str .= "font-size:".$size.";";
    $str .= "line-height:".$lineheight.";";

    return $str;
}


function uport_common_css_h($val3arr) {
    ob_start();
    echo uport_common_font('title',$val3arr);
    ?>
    color: <?php echo trim($val3arr['titlecolor']); ?>;
    background: <?php echo trim($val3arr['titlebgcolor']); ?>;
    text-align: <?php echo trim($val3arr['titlealign']); ?>;
    padding: <?php echo trim($val3arr['titlepaddingtop']); ?> <?php echo trim($val3arr['titlepaddingright']); ?> <?php echo trim($val3arr['titlepaddingbottom']); ?> <?php echo trim($val3arr['titlepaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['titlemargintop']); ?> <?php echo trim($val3arr['titlemarginright']); ?> <?php echo trim($val3arr['titlemarginbottom']); ?> <?php echo trim($val3arr['titlemarginleft']); ?> ;
    <?php
    return ob_get_clean();
}

function uport_common_css_maskbg($val3arr) {
    ob_start();

    if(!isset($val3arr['bgopacity'])){ $val3arr['bgopacity'] = "1"; }
    if(isset($val3arr['bgcolor']) && trim($val3arr['bgcolor']) != ""){
    ?>
    background-color: <?php echo uport_hex2rgba($val3arr['bgcolor'], $val3arr['bgopacity']); ?>;
    <?php
    } 
    return ob_get_clean();
}

function uport_common_css_outbg($val3arr) {
    ob_start();

    if(!isset($val3arr['outbgopacity'])){ $val3arr['outbgopacity'] = "1"; }
    if(isset($val3arr['outbgcolor']) && trim($val3arr['outbgcolor']) != ""){
    ?>
    background-color: <?php echo uport_hex2rgba($val3arr['outbgcolor'], $val3arr['outbgopacity']); ?>;
    <?php
    } 
    return ob_get_clean();
}

function uport_common_css_portbg($val3arr) {
    ob_start();

    if(!isset($val3arr['portbgopacity'])){ $val3arr['portbgopacity'] = "1"; }
    if(isset($val3arr['portbgcolor']) && trim($val3arr['portbgcolor']) != ""){
    ?>
    background-color: <?php echo uport_hex2rgba($val3arr['portbgcolor'], $val3arr['portbgopacity']); ?>;
    <?php
    } ?>
    
    padding: <?php echo trim($val3arr['portpaddingtop']); ?> <?php echo trim($val3arr['portpaddingright']); ?> <?php echo trim($val3arr['portpaddingbottom']); ?> <?php echo trim($val3arr['portpaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['portmargintop']); ?> <?php echo trim($val3arr['portmarginright']); ?> <?php echo trim($val3arr['portmarginbottom']); ?> <?php echo trim($val3arr['portmarginleft']); ?> ;
    
    <?php
    return ob_get_clean();
}

function uport_common_css_but($val3arr) {
    ob_start();
    echo uport_common_font('but',$val3arr);
    ?>
    text-decoration:none;
    display: inline-block;
    text-align:center;
    color: <?php echo trim($val3arr['butcolor']); ?>;
    background: <?php echo trim($val3arr['butbgcolor']); ?>;
    padding: <?php echo trim($val3arr['butpaddingtop']); ?> <?php echo trim($val3arr['butpaddingright']); ?> <?php echo trim($val3arr['butpaddingbottom']); ?> <?php echo trim($val3arr['butpaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['butmargintop']); ?> <?php echo trim($val3arr['butmarginright']); ?> <?php echo trim($val3arr['butmarginbottom']); ?> <?php echo trim($val3arr['butmarginleft']); ?> ;
    border: <?php echo trim($val3arr['butborderwidth']); ?> solid <?php echo trim($val3arr['butbordercolor']); ?>;
    border-radius: <?php echo trim($val3arr['butborderradius']); ?>;
    -webkit-border-radius: <?php echo trim($val3arr['butborderradius']); ?>;
    -moz-border-radius: <?php echo trim($val3arr['butborderradius']); ?>;
    -o-border-radius: <?php echo trim($val3arr['butborderradius']); ?>;
    -ms-border-radius: <?php echo trim($val3arr['butborderradius']); ?>;
    <?php
    if (trim($val3arr['butalign']) == "center") {
        echo "float:none;";
    }
    if (trim($val3arr['butalign']) == "left") {
        echo "float:left;";
    }
    if (trim($val3arr['butalign']) == "right") {
        echo "float:right;";
    }

    return ob_get_clean();
}

function uport_common_css_buthover($val3arr) {
    ob_start();
    ?>
    background: <?php echo trim($val3arr['butbgcolor2']); ?>;
    <?php
    return ob_get_clean();
}

function uport_common_css_desc($val3arr) {
    ob_start();
    echo uport_common_font('desc',$val3arr);
    ?>
    color: <?php echo trim($val3arr['desccolor']); ?>;
    background: <?php echo trim($val3arr['descbgcolor']); ?>;
    text-align: <?php echo trim($val3arr['descalign']); ?>;
    padding: <?php echo trim($val3arr['descpaddingtop']); ?> <?php echo trim($val3arr['descpaddingright']); ?> <?php echo trim($val3arr['descpaddingbottom']); ?> <?php echo trim($val3arr['descpaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['descmargintop']); ?> <?php echo trim($val3arr['descmarginright']); ?> <?php echo trim($val3arr['descmarginbottom']); ?> <?php echo trim($val3arr['descmarginleft']); ?> ;
    <?php
    return ob_get_clean();
}

function uport_common_css_slug($val3arr) {
    ob_start();
    echo uport_common_font('slug',$val3arr);
    ?>
    color: <?php echo trim($val3arr['slugcolor']); ?>;
    background: <?php echo trim($val3arr['slugbgcolor']); ?>;
    text-align: <?php echo trim($val3arr['slugalign']); ?>;
    padding: <?php echo trim($val3arr['slugpaddingtop']); ?> <?php echo trim($val3arr['slugpaddingright']); ?> <?php echo trim($val3arr['slugpaddingbottom']); ?> <?php echo trim($val3arr['slugpaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['slugmargintop']); ?> <?php echo trim($val3arr['slugmarginright']); ?> <?php echo trim($val3arr['slugmarginbottom']); ?> <?php echo trim($val3arr['slugmarginleft']); ?> ;
    position: relative;
    display: block;
    clear: both;
    <?php
    return ob_get_clean();
}

function uport_common_css_price($val3arr) {
    ob_start();
    echo uport_common_font('price',$val3arr);
    ?>
    color: <?php echo trim($val3arr['pricecolor']); ?>;
    background: <?php echo trim($val3arr['pricebgcolor']); ?>;
    text-align: <?php echo trim($val3arr['pricealign']); ?>;
    padding: <?php echo trim($val3arr['pricepaddingtop']); ?> <?php echo trim($val3arr['pricepaddingright']); ?> <?php echo trim($val3arr['pricepaddingbottom']); ?> <?php echo trim($val3arr['pricepaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['pricemargintop']); ?> <?php echo trim($val3arr['pricemarginright']); ?> <?php echo trim($val3arr['pricemarginbottom']); ?> <?php echo trim($val3arr['pricemarginleft']); ?> ;
    <?php
    return ob_get_clean();
}


function uport_common_css_above($val3arr) {
    ob_start();
    echo uport_common_font('above',$val3arr);
    ?>
    color: <?php echo trim($val3arr['abovecolor']); ?>;
    background: <?php echo trim($val3arr['abovebgcolor']); ?>;
    text-align: <?php echo trim($val3arr['abovealign']); ?>;
    padding: <?php echo trim($val3arr['abovepaddingtop']); ?> <?php echo trim($val3arr['abovepaddingright']); ?> <?php echo trim($val3arr['abovepaddingbottom']); ?> <?php echo trim($val3arr['abovepaddingleft']); ?> ;
    margin: <?php echo trim($val3arr['abovemargintop']); ?> <?php echo trim($val3arr['abovemarginright']); ?> <?php echo trim($val3arr['abovemarginbottom']); ?> <?php echo trim($val3arr['abovemarginleft']); ?> ;
    <?php

    if(isset($val3arr['abovepos']) && $val3arr['abovepos'] == "top"){
        echo "top: 0px !important;bottom:auto !important;";
    }
    
    if(isset($val3arr['abovepos']) && $val3arr['abovepos'] == "bottom"){
        echo "top: auto !important;bottom:0px !important;";
    }

    return ob_get_clean();
}
?>