<?php
/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
?>


<?php

/*Outer style settings*/

$outer_style = $val2arr['outerstyle'];

$outmaskclass = uport_out_class('mask',$pid,$outer_style);

echo uport_out_style($outer_style,$pid);


/*Google font settings*/
echo uport_gfont_style($pid,$val3arr);

if ($loadscript != "" && isset($loadscript) && $loadscript == "mix") {
// mixitub
    do_action('uport_mix_hook');
    do_action('uport_fancypox_hook');
    ?>

    <script type='text/javascript'>
                jQuery(function() {
                'use strict';
                jQuery('.uport-grid-<?php echo $pid; ?>').mixitub({
                targetSelector: '.uport-view-<?php echo $pid; ?>',
                        filterSelector: '.filter-<?php echo $pid; ?>',
                        effects: [<?php echo $mixeffects; ?>], //'fade', 'scale', 'rotateZ', 'rotateX'*, 'rotateY'*, 'blur'*, and 'grayscale'*.
                        easing: '<?php echo $mixeasing; ?>', // 'smooth', 'snap', 'windup'*, and 'windback'* , 'cubic-bezier(0.175, 0.885, 0.320, 1.275)'
                        transitionSpeed: <?php echo $mixspeed; ?>,
                });
                });
                jQuery('.uport-fancy-<?php echo $pid; ?>')
                .attr('rel', 'media-gallery')
                .fancypox({
                openEffect: 'none',
                        closeEffect: 'none',
                        titleFromAlt: true,
                        arrows: true,
                        helpers: {
                        overlay: {locked: false},
                                media: {},
                                buttons: {}
                        }
                })</script>

<?php } ?>


<?php
if ($loadscript != "" && isset($loadscript) && $loadscript == "iso") {
// isotobe
    do_action('uport_iso_hook');
    do_action('uport_fancypox_hook');
    ?>
    <script type='text/javascript'>
               jQuery(window).load(function(){
                var container = $('.uport-grid-<?php echo $pid; ?>');
                        container.isotobe({
                                layoutMode: 'sloppyMasonry',
                                itemSelector: '.uport-view-<?php echo $pid; ?>',
                                filter: '*',
                                animationEngine : 'best-available',
                                animationOptions: {
                                duration: <?php echo $mixspeed; ?>,
                                        easing: 'linear',
                                        queue: false
                                }
                        });

                        jQuery('.uport-cats-<?php echo $pid; ?> .filter-<?php echo $pid; ?>').on('click', function(e) {
                        
                            jQuery('.uport-cats-<?php echo $pid; ?> .filter-<?php echo $pid; ?>.active').removeClass('active');
                            jQuery(this).addClass('active');
                            var selector = "." + jQuery(this).attr('data-filter');
                            // condition for isotobe only
                            console.log(selector);
                            if (selector == ".all"){ selector = "*"; }
                            //console.log(selector);
    
                            container.isotobe({
                            filter: selector,
                                    animationOptions: {
                                    duration: <?php echo $mixspeed; ?>,
                                            easing: 'linear',
                                            queue: false
                                    }
                            });
                            return false;
                        });
                    });


                jQuery('.uport-fancy-<?php echo $pid; ?>')
                .attr('rel', 'media-gallery')
                .fancypox({
                openEffect: 'none',
                        closeEffect: 'none',
                        titleFromAlt: true,
                        arrows: true,
                        helpers: {
                        overlay: {locked: false},
                                media: {},
                                buttons: {}
                        }
                });</script>

    <style type='text/css'>

        .uport-grid-<?php echo $pid; ?>.iso_<?php echo $isoeffect; ?>, .uport-view-<?php echo $pid; ?>.iso_<?php echo $isoeffect; ?>{
            -webkit-transition-duration: <?php echo trim($mixspeed); ?>ms;
            -moz-transition-duration: <?php echo trim($mixspeed); ?>ms;
            transition-duration: <?php echo trim($mixspeed); ?>ms;
            -o-transition-duration: <?php echo trim($mixspeed); ?>ms;
            -ms-transition-duration: <?php echo trim($mixspeed); ?>ms;
            <?php echo uport_css_animation_type($isoeffect); ?>
        }

    </style>

<?php } ?>


<?php
if ($loadscript != "" && isset($loadscript) && $loadscript == "owl") {
// owl
    do_action('uport_owl_hook');
    do_action('uport_fancypox_hook');
//print_r($val4arr); print_r($val2arr);

    $slideSpeed = 200;
    $paginationSpeed = 800;
    $rewindSpeed = 1000;

    $autoplay = "true";
    $navigation = "false";
    $pagination = "true";
    $scrollPerPage = "true";

    $playstop = "false";
    $lazyLoad = "true";
    $nexticon = "&raquo;";
    $previcon = "&laquo;";


    if (is_numeric($val4arr['owlslidespeed'])) {
        $slideSpeed = $val4arr['owlslidespeed'];
    }
    if (is_numeric($val4arr['owlpagespeed'])) {
        $paginationSpeed = $val4arr['owlpagespeed'];
    }
    if (is_numeric($val4arr['owlrewindspeed'])) {
        $rewindSpeed = $val4arr['owlrewindspeed'];
    }

    $autoplay = uport_radiovalue($val4arr['owlautoplay'], $autoplay);
    //$navigation = uport_radiovalue($val4arr['owlnavigation'], $navigation);
    $pagination = uport_radiovalue($val4arr['owlpagination'], $pagination);
    $scrollPerPage = uport_radiovalue($val4arr['owlscrollPerPage'], $scrollPerPage);
    $playstop = uport_radiovalue($val4arr['owlplaystop'], $playstop);
    ?>

    <script type='text/javascript'>
                jQuery(function() {
                    'use strict';

                var owl = jQuery('.uport-grid-<?php echo $pid; ?>');
                        owl.owlCarousel({
    <?php if (isset($val2arr['uporttype']) && $val2arr['uporttype'] == "single") { ?>
                            items : 1,
                                    itemsDesktop : false,
                                    itemsDesktopSmall : false,
                                    itemsTablet : false,
                                    itemsMobile : false,
                                    singleItem:true,
    <?php } else { ?>
                            items : <?php echo $val2arr['noofcolumns1']; ?>,
                                    itemsDesktop : [1199,<?php echo $val2arr['noofcolumns1']; ?>],
                                    itemsDesktopSmall : [979,<?php echo $val2arr['noofcolumns2']; ?>],
                                    itemsTablet : [768,<?php echo $val2arr['noofcolumns3']; ?>],
                                    itemsMobile : [479,<?php echo $val2arr['noofcolumns4']; ?>],
    <?php } ?>
                                
                                slideSpeed : <?php echo $slideSpeed; ?>,
                                paginationSpeed : <?php echo $paginationSpeed; ?>,
                                rewindSpeed : <?php echo $rewindSpeed; ?>,
                                autoPlay: <?php echo $autoplay; ?>,
                                navigation : <?php echo $navigation; ?>,
                                scrollPerPage : <?php echo $scrollPerPage; ?>,
                                pagination : <?php echo $pagination; ?>,
                                lazyLoad : <?php echo $lazyLoad; ?>,
                                navigationText : ["<?php echo $previcon; ?>", "<?php echo $nexticon; ?>"],
                        });
                        // Custom Navigation Events
                        jQuery(".uport-slide-next-<?php echo $pid; ?>").on('click', function(e) {
                            owl.trigger('owl.next');
                        })
                        jQuery(".uport-slide-prev-<?php echo $pid; ?>").on('click', function(e) {
                            owl.trigger('owl.prev');
                        })
                        jQuery(".uport-slide-play-<?php echo $pid; ?>").on('click', function(e) {
                            owl.trigger('owl.play', 1000);
                            jQuery(this).hide();
                            jQuery(".uport-slide-stop-<?php echo $pid; ?>").show();
                        })
                        jQuery(".uport-slide-stop-<?php echo $pid; ?>").on('click', function(e) {
                            owl.trigger('owl.stop');
                            jQuery(this).hide();
                            jQuery(".uport-slide-play-<?php echo $pid; ?>").show();
                        })


                });
                jQuery('.uport-fancy-<?php echo $pid; ?>')
                .attr('rel', 'media-gallery')
                .fancypox({
                openEffect: 'none',
                        closeEffect: 'none',
                        titleFromAlt: true,
                        arrows: true,
                        helpers: {
                        overlay: {locked: false},
                                media: {},
                                buttons: {}
                        }
                });


    </script>

    <?php
}
?>