<?php

/*
  Plugin Name: Ultra Portfolio - WordPress
  Plugin URI: http://codecanyon.net/user/themepassion/portfolio
  Description: Fully Featured Portfolio Plugin. Best Portfolio Plugin.
  Version: 6.5
  Author: themepassion
  Author URI: http://codecanyon.net/user/themepassion/portfolio
  Copyright 2014-2021 themepassion

 */

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
/* --------------- Enqueue Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-enqueue.php' );


/* --------------- Admin Menu Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-menu.php' );

/* --------------- Enqueue Library---------------- */
if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-functions.mc.php' );
} else {
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-functions.php' );
}

/* --------------- Effects Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-effects.php' );

/* --------------- Item Elements Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-item-elements.php' );

/* --------------- Display elements Library---------------- */
if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-display-elements.mc.php' );
} else {
    require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-display-elements.php' );
}

/* --------------- Page Type Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-page.php' );


/* --------------- Ajax Panel Library---------------- */
if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-ajax-panels.mc.php' );
} else {
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-ajax-panels.php' );
}


/* --------------- Item Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-item.php' );


/* --------------- Category Library---------------- */
if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-category.mc.php' );
} else {
    require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-category.php' );
}

/* --------------- Dashboard Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-dashboard.php' );


/* --------------- Demo Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-demo.php' );

/* --------------- Shortcode Library---------------- */
if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-shortcode.mc.php' );
} else {
    require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-shortcode.php' );
}

/* --------------- Common CSS Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-common-css.php' );


/* --------------- Effect Based CSS Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'shortcode/uport-effect-css.php' );

if(file_exists(plugin_dir_path( __FILE__ ).'lib/uport-multicat-index.mc.php')){
    add_action('wp_ajax_uport_cat_filter', 'uport_cat_filter');
}


/* --------------- Registration Hook Library---------------- */
require_once( trailingslashit(dirname(__FILE__)) . 'lib/uport-register-hook.php' );
register_activation_hook(__FILE__, 'uport_activation');
register_deactivation_hook(__FILE__, 'uport_deactivation');

/*Language textdomain*/
load_plugin_textdomain( 'uport-framework', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

?>